<?php

class Awardit_Integration_Block_Renderer_Qty extends Mage_Adminhtml_Block_Widget_Grid_Column_Renderer_Number
{
    public function render(Varien_Object $row)
    {
        $sku = $row->getData('sku');
        if (empty($sku)) {
            return false;
        }
        $extQty = $this->getExtQty($sku);
        // Overload if has entry in stock table
        if ($extQty !== false) {
            $row->setData('qty', $extQty);
        }
        return parent::render($row);
    }

    private function getExtQty(string $sku)
    {
        try {
            $sqlQuery = "SELECT SUM(stock.qty) AS qty "
                      . "FROM stock "
                      . "WHERE stock.warehouse_id = ? "
                      . "AND (stock.magento_id = 0 OR stock.magento_id = ?) "
                      . "AND (stock.store_id = 0 OR stock.store_id = ?) "
                      . "AND stock.sku = ? "
                      . "GROUP BY stock.sku";
            $params = [
                (int)Mage::getStoreConfig('integration/external_stock/warehouse_id'),
                (int)Mage::getStoreConfig('integration/general/magento_instance'),
                (int)Mage::app()->getStore()->getId(),
                $sku,
            ];
            return Mage::getSingleton('core/resource')
                ->getConnection('stock_handler_read')
                ->fetchOne($sqlQuery, $params);
        } catch (Exception $exception) {
            Mage::helper('integration')->logException($exception, "Exception while checking external stock data for collection!");
            return false;
        }
    }
}
