<?php

class Awardit_Integration_Block_Override_AdminhtmlCatalogProductGrid extends Mage_Adminhtml_Block_Catalog_Product_Grid
{

    private $_externalStockEnabled = false;

    public function _construct()
    {
        $this->_externalStockEnabled = Mage::getStoreConfig('integration/external_stock/enabled', Mage::app()->getStore()->getId()) ? true : false;
        parent::_construct();
    }

    protected function _prepareCollection()
    {
        // Prepare the collection
        parent::_prepareCollection();

        // Check to see if external stock handling is activated
        if ($this->_externalStockEnabled) {

            // If so, build array of SKUs to use
            $skus = [];
            foreach ($this->getCollection() as $product) {
                $skus[] = "'{$product->getSku()}'";
            }

            // Check to se if we got any SKUs
            if (!empty($skus)) {

                try {
                    // If so, fetch external qty for them
                    $skuString = implode(',', $skus);
                    $sqlQuery = "SELECT stock.sku, SUM(stock.qty) AS qty FROM stock WHERE stock.warehouse_id = ? AND (stock.magento_id = 0 OR stock.magento_id = ?) AND (stock.store_id = 0 OR stock.store_id = ?) AND stock.sku IN ({$skuString}) GROUP BY stock.sku";
                    $params = [
                        Mage::getStoreConfig('integration/external_stock/warehouse_id') - 0,
                        Mage::getStoreConfig('integration/general/magento_instance') - 0,
                        Mage::app()->getStore()->getId() - 0
                    ];
                    $result = Mage::getSingleton('core/resource')->getConnection('stock_handler_read')->fetchAssoc($sqlQuery, $params);

                    // Check to see if we got any data
                    if (!empty($result)) {

                        // If so, loop through the collection
                        foreach ($this->getCollection() as $product) {

                            // Check to se if we got result for matching SKU
                            if (array_key_exists($product->getSku(), $result)) {

                                // If so, update qty with correct value from external source
                                $product->setData('qty', $result[$product->getSku()]['qty']);
                            }
                        }
                    }
                } catch (Exception $exception) {
                    Mage::logException($exception);

                    return false;
                }
            }
        }

        return $this;
    }

}
