<?php

/**
 * @psalm-scope-this Mage_Core_Model_Resource_Setup
 */
$installer = $this;

$installer->startSetup();

$connection = $installer->getConnection();

$installer->run("
    CREATE TABLE IF NOT EXISTS `awardit_integration_orders` (
        `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
        `increment_id` VARCHAR(50) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
        `magento_order_id` INT(10) UNSIGNED NULL DEFAULT '0',
        `magento_status` VARCHAR(50) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
        `order_category` INT(11) NULL DEFAULT '1102',
        `visma_order_id` VARCHAR(50) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
        `visma_db` VARCHAR(5) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
        `visma_status` INT(10) UNSIGNED NULL DEFAULT '0',
        `export_status` INT(10) UNSIGNED NULL DEFAULT '0',
        PRIMARY KEY (`id`) USING BTREE,
        UNIQUE INDEX `FK_awardit_order_integration_sales_flat_order` (`magento_order_id`) USING BTREE,
        INDEX `Index3` (`export_status`) USING BTREE,
        CONSTRAINT `FK_awardit_order_integration_sales_flat_order` FOREIGN KEY (`magento_order_id`) REFERENCES `sales_flat_order` (`entity_id`) ON UPDATE CASCADE ON DELETE CASCADE
    )
    COLLATE='utf8_general_ci'
    ENGINE=InnoDB
");

$installer->run("
    CREATE TABLE IF NOT EXISTS `awardit_integration_products` (
        `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
        `sku` VARCHAR(50) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
        `created_at` TIMESTAMP NULL DEFAULT current_timestamp(),
        `imported_at` TIMESTAMP NULL DEFAULT NULL,
        `visma_status` INT(10) UNSIGNED NULL DEFAULT '0',
        `import_status` INT(10) UNSIGNED NOT NULL DEFAULT '0',
        `price_data` TEXT NULL DEFAULT NULL COMMENT 'JSON data' COLLATE 'utf8_general_ci',
        `stock_data` TEXT NULL DEFAULT NULL COMMENT 'JSON data' COLLATE 'utf8_general_ci',
        `extra_data` TEXT NULL DEFAULT NULL COMMENT 'JSON data' COLLATE 'utf8_general_ci',
        PRIMARY KEY (`id`) USING BTREE,
        UNIQUE INDEX `Index1` (`sku`) USING BTREE
    )
    COLLATE='utf8_general_ci'
    ENGINE=InnoDB
");

$installer->run("
    CREATE TABLE IF NOT EXISTS `awardit_pointsales` (
        `order_id` INT(10) UNSIGNED NOT NULL,
        `increment_id` VARCHAR(50) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
        `created_at` TIMESTAMP NULL DEFAULT NULL,
        `pointsales_value` FLOAT NULL DEFAULT NULL,
        `currency_id` INT(10) UNSIGNED NULL DEFAULT NULL,
        `payment_ref` VARCHAR(128) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
        `company_db` VARCHAR(5) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
        `processing_status` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
        `processing_date` TIMESTAMP NULL DEFAULT NULL,
        PRIMARY KEY (`order_id`) USING BTREE,
        CONSTRAINT `FK_awardit_pointsales_sales_flat_order` FOREIGN KEY (`order_id`) REFERENCES `sales_flat_order` (`entity_id`) ON UPDATE CASCADE ON DELETE CASCADE
    )
    COLLATE='utf8_general_ci'
    ENGINE=InnoDB
");

$installer->run("
    CREATE TABLE IF NOT EXISTS `awardit_accrual` (
        `order_id` INT(10) UNSIGNED NOT NULL,
        `increment_id` VARCHAR(50) NOT NULL COLLATE 'utf8_general_ci',
        `payout_points` INT(10) UNSIGNED NOT NULL DEFAULT '0',
        `payout_date` DATE NOT NULL,
        `payout_tries` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
        `payout_status` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0 = Waiting, 1 = Processed, 9 = Error',
        `transaction_id` VARCHAR(20) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
        PRIMARY KEY (`order_id`) USING BTREE,
	INDEX `payout_date_idx` (`payout_date`) USING BTREE,
	INDEX `payout_status_idx` (`payout_status`) USING BTREE,
        CONSTRAINT `FK1_awardit_accrual_sales_flat_order` FOREIGN KEY (`order_id`) REFERENCES `sales_flat_order` (`entity_id`) ON UPDATE CASCADE ON DELETE CASCADE
    )
    COLLATE='utf8_general_ci'
    ENGINE=InnoDB
");

if (!$connection->tableColumnExists('customer_group', 'visma_group_id')) {
    $installer->run("ALTER TABLE `customer_group` ADD COLUMN `visma_group_id` INT(10) UNSIGNED NULL DEFAULT '0' COMMENT 'Group Id in Visma' AFTER `tax_class_id`");
}


$installer->endSetup();

/*
    Sas 2.0 data for table `tax_translations` in database `integration`
    ! Only insert data once, table is missing UNIQUE settings
    ---
    INSERT INTO `tax_translations` (`magento_instance`, `magento_tax_id`, `swedish_visma_tax_id`, `tax_percent`, `currency_id`, `country_id`, `local_visma_tax_id`) VALUES
    (18, 2, 1, 25, 0, 0, 1),
    (18, 4, 2, 12, 0, 0, 2),
    (18, 5, 3, 6, 0, 0, 3),
    (18, 0, 27, 0, 0, 0, 27),
    (18, 2, 1, 25, 46, 0, 1),
    (18, 4, 2, 12, 46, 0, 2),
    (18, 5, 3, 6, 46, 0, 3),
    (18, 0, 27, 0, 46, 0, 27),
    (18, 6, 1, 25, 47, 0, 3),
    (18, 7, 2, 15, 47, 0, 13),
    (18, 8, 3, 12, 47, 0, 15),
    (18, 0, 27, 0, 47, 0, 27),
    (18, 9, 1, 25, 45, 0, 1),
    (18, 0, 27, 0, 45, 0, 2),
    (18, 10, 1, 24, 99, 358, 11),
    (18, 11, 2, 14, 99, 358, 12),
    (18, 12, 3, 10, 99, 358, 13),
    (18, 0, 27, 0, 99, 358, 14),
    (18, 2, 1, 24, 99, 358, 11),
    (18, 4, 2, 14, 99, 358, 12),
    (18, 5, 3, 10, 99, 358, 13),
    (18, 9, 3, 25, 45, 0, 1),
    (18, 9, 2, 25, 45, 0, 1)
 */