# Protocol Documentation
<a name="top"></a>

## Table of Contents

- [awardit/inventory/v1/inventory_service.proto](#awardit_inventory_v1_inventory_service-proto)
    - [ListStockItemsRequest](#awardit-inventory-v1-ListStockItemsRequest)
    - [ListStockItemsResponse](#awardit-inventory-v1-ListStockItemsResponse)
    - [StockItem](#awardit-inventory-v1-StockItem)
    - [StockItemFilter](#awardit-inventory-v1-StockItemFilter)
    - [StreamStockItemsRequest](#awardit-inventory-v1-StreamStockItemsRequest)
  
    - [Inventory](#awardit-inventory-v1-Inventory)
  
- [awardit/order/common.proto](#awardit_order_common-proto)
    - [TrackingNumber](#awardit-order-TrackingNumber)
  
    - [OrderStatus](#awardit-order-OrderStatus)
  
- [awardit/order/v1/order_service.proto](#awardit_order_v1_order_service-proto)
    - [GetOrderStatusInformationRequest](#awardit-order-v1-GetOrderStatusInformationRequest)
    - [OrderStatusInformation](#awardit-order-v1-OrderStatusInformation)
  
    - [Order](#awardit-order-v1-Order)
  
- [Scalar Value Types](#scalar-value-types)



<a name="awardit_inventory_v1_inventory_service-proto"></a>
<p align="right"><a href="#top">Top</a></p>

## awardit/inventory/v1/inventory_service.proto
Inventory management, including querying inventory status for products.


<a name="awardit-inventory-v1-ListStockItemsRequest"></a>

### ListStockItemsRequest
Filter parameters for the ListItems method.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| filter | [StockItemFilter](#awardit-inventory-v1-StockItemFilter) | optional | Optional. Filters for the stock items to return. |
| page_size | [int32](#int32) |  | Optional. The page size of the response. |
| page_token | [string](#string) |  | Optional. Token for which page to return, obtained from next_page_token.

Leave empty for the first page. |






<a name="awardit-inventory-v1-ListStockItemsResponse"></a>

### ListStockItemsResponse
Response from ListItems


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| items | [StockItem](#awardit-inventory-v1-StockItem) | repeated | StockItems matching the supplied filters. |
| next_page_token | [string](#string) |  | Optional. Token used to obtain the next page.

Empty if this is the last page. |






<a name="awardit-inventory-v1-StockItem"></a>

### StockItem
Information about a stock item.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| sku | [string](#string) |  | Product SKU/Stock-keeping-unit, globally unique for each product. |
| warehouse_id | [string](#string) |  | Which warehouse these items are contained in. UUID in string-format. |
| read_time | [google.protobuf.Timestamp](#google-protobuf-Timestamp) |  | When this stock item was read, UTC per definition. |
| updated_time | [google.protobuf.Timestamp](#google-protobuf-Timestamp) |  | When this stock item was last modified. |
| available_quantity | [int64](#int64) |  | Available item quantity. |






<a name="awardit-inventory-v1-StockItemFilter"></a>

### StockItemFilter
Filter parameters for the StreamItems method.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| sku | [string](#string) | optional | Optional. Product SKU to filter inventory items by. |
| warehouse_id | [string](#string) | optional | Optional. Warehouse to filter results by. UUID in string-format.

Note: The available warehouse-ids depend on the permissions granted to the client. |
| modified_since_time | [google.protobuf.Timestamp](#google-protobuf-Timestamp) | optional | Optional. Timestamp to filter results by, will include items created or updated after the given timestamp. |






<a name="awardit-inventory-v1-StreamStockItemsRequest"></a>

### StreamStockItemsRequest
Request for streamed StockItems.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| filter | [StockItemFilter](#awardit-inventory-v1-StockItemFilter) | optional | Optional. Filters for the stock items to return. |





 

 

 


<a name="awardit-inventory-v1-Inventory"></a>

### Inventory
Service exposing inventory information.

| Method Name | Request Type | Response Type | Description |
| ----------- | ------------ | ------------- | ------------|
| StreamStockItems | [StreamStockItemsRequest](#awardit-inventory-v1-StreamStockItemsRequest) | [StockItem](#awardit-inventory-v1-StockItem) stream | Returns a stream of items matching the given filters. |
| ListStockItems | [ListStockItemsRequest](#awardit-inventory-v1-ListStockItemsRequest) | [ListStockItemsResponse](#awardit-inventory-v1-ListStockItemsResponse) | Query stock items based on a filter, returning a paginated result. |

 



<a name="awardit_order_common-proto"></a>
<p align="right"><a href="#top">Top</a></p>

## awardit/order/common.proto



<a name="awardit-order-TrackingNumber"></a>

### TrackingNumber
Tracking number for a parcel which is to be sent or has been sent.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| number | [string](#string) |  | Tracking number for a parcel. |





 


<a name="awardit-order-OrderStatus"></a>

### OrderStatus
Status describing the current phase the order is in.

| Name | Number | Description |
| ---- | ------ | ----------- |
| ORDER_STATUS_UNSPECIFIED | 0 | Unknown order status. |
| ORDER_STATUS_ORDERED | 1 | Order has been created. |
| ORDER_STATUS_HOLD | 2 | Order is on-hold. |
| ORDER_STATUS_PICKING | 3 | Order-items are being picked. |
| ORDER_STATUS_FULFILLED | 4 | Order has been fulfilled (shipped/packaged/pending-sending). |
| ORDER_STATUS_CANCELLED | 5 | Order has been cancelled. |


 

 

 



<a name="awardit_order_v1_order_service-proto"></a>
<p align="right"><a href="#top">Top</a></p>

## awardit/order/v1/order_service.proto
Datatypes and services for orders.


<a name="awardit-order-v1-GetOrderStatusInformationRequest"></a>

### GetOrderStatusInformationRequest
Request for querying order status of a specific order.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| order_id | [string](#string) |  | Required. Order identifier. |






<a name="awardit-order-v1-OrderStatusInformation"></a>

### OrderStatusInformation
The current order status information for the requested order id.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| order_id | [string](#string) |  | Order identifier. |
| order_status | [awardit.order.OrderStatus](#awardit-order-OrderStatus) |  | Order status. |
| created_time | [google.protobuf.Timestamp](#google-protobuf-Timestamp) |  | When the order was created. |
| updated_time | [google.protobuf.Timestamp](#google-protobuf-Timestamp) |  | When the order was last updated. |
| tracking_numbers | [awardit.order.TrackingNumber](#awardit-order-TrackingNumber) | repeated | Parcels for the order, will be empty for virtual orders or if the order has not yet been picked.

Some shipping methods do not provide any tracking information or parcel data. |





 

 

 


<a name="awardit-order-v1-Order"></a>

### Order
Service for querying information about orders.

| Method Name | Request Type | Response Type | Description |
| ----------- | ------------ | ------------- | ------------|
| GetOrderStatusInformation | [GetOrderStatusInformationRequest](#awardit-order-v1-GetOrderStatusInformationRequest) | [OrderStatusInformation](#awardit-order-v1-OrderStatusInformation) | Attempts to retrieve the order-status of a given order. |

 



## Scalar Value Types

| .proto Type | Notes | C++ | Java | Python | Go | C# | PHP | Ruby |
| ----------- | ----- | --- | ---- | ------ | -- | -- | --- | ---- |
| <a name="double" /> double |  | double | double | float | float64 | double | float | Float |
| <a name="float" /> float |  | float | float | float | float32 | float | float | Float |
| <a name="int32" /> int32 | Uses variable-length encoding. Inefficient for encoding negative numbers – if your field is likely to have negative values, use sint32 instead. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="int64" /> int64 | Uses variable-length encoding. Inefficient for encoding negative numbers – if your field is likely to have negative values, use sint64 instead. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="uint32" /> uint32 | Uses variable-length encoding. | uint32 | int | int/long | uint32 | uint | integer | Bignum or Fixnum (as required) |
| <a name="uint64" /> uint64 | Uses variable-length encoding. | uint64 | long | int/long | uint64 | ulong | integer/string | Bignum or Fixnum (as required) |
| <a name="sint32" /> sint32 | Uses variable-length encoding. Signed int value. These more efficiently encode negative numbers than regular int32s. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="sint64" /> sint64 | Uses variable-length encoding. Signed int value. These more efficiently encode negative numbers than regular int64s. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="fixed32" /> fixed32 | Always four bytes. More efficient than uint32 if values are often greater than 2^28. | uint32 | int | int | uint32 | uint | integer | Bignum or Fixnum (as required) |
| <a name="fixed64" /> fixed64 | Always eight bytes. More efficient than uint64 if values are often greater than 2^56. | uint64 | long | int/long | uint64 | ulong | integer/string | Bignum |
| <a name="sfixed32" /> sfixed32 | Always four bytes. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="sfixed64" /> sfixed64 | Always eight bytes. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="bool" /> bool |  | bool | boolean | boolean | bool | bool | boolean | TrueClass/FalseClass |
| <a name="string" /> string | A string must always contain UTF-8 encoded or 7-bit ASCII text. | string | String | str/unicode | string | string | string | String (UTF-8) |
| <a name="bytes" /> bytes | May contain any arbitrary sequence of bytes. | string | ByteString | str | []byte | ByteString | string | String (ASCII-8BIT) |

