
1
google/protobuf/timestamp.protogoogle.protobuf";
	Timestamp
seconds (Rseconds
nanos (RnanosB
com.google.protobufBTimestampProtoPZ2google.golang.org/protobuf/types/known/timestamppbGPBGoogle.Protobuf.WellKnownTypesJ/
 

 2 Protocol Buffers - Google's data interchange format
 Copyright 2008 Google Inc.  All rights reserved.
 https://developers.google.com/protocol-buffers/

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are
 met:

     * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above
 copyright notice, this list of conditions and the following disclaimer
 in the documentation and/or other materials provided with the
 distribution.
     * Neither the name of Google Inc. nor the names of its
 contributors may be used to endorse or promote products derived from
 this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


  

" 
	
" 

# I
	
# I

$ ,
	
$ ,

% /
	
% /

& "
	

& "

' !
	
$' !

( ;
	
%( ;

   A Timestamp represents a point in time independent of any time zone or local
 calendar, encoded as a count of seconds and fractions of seconds at
 nanosecond resolution. The count is relative to an epoch at UTC midnight on
 January 1, 1970, in the proleptic Gregorian calendar which extends the
 Gregorian calendar backwards to year one.

 All minutes are 60 seconds long. Leap seconds are "smeared" so that no leap
 second table is needed for interpretation, using a [24-hour linear
 smear](https://developers.google.com/time/smear).

 The range is from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z. By
 restricting to that range, we ensure that we can convert to and from [RFC
 3339](https://www.ietf.org/rfc/rfc3339.txt) date strings.

 # Examples

 Example 1: Compute Timestamp from POSIX `time()`.

     Timestamp timestamp;
     timestamp.set_seconds(time(NULL));
     timestamp.set_nanos(0);

 Example 2: Compute Timestamp from POSIX `gettimeofday()`.

     struct timeval tv;
     gettimeofday(&tv, NULL);

     Timestamp timestamp;
     timestamp.set_seconds(tv.tv_sec);
     timestamp.set_nanos(tv.tv_usec * 1000);

 Example 3: Compute Timestamp from Win32 `GetSystemTimeAsFileTime()`.

     FILETIME ft;
     GetSystemTimeAsFileTime(&ft);
     UINT64 ticks = (((UINT64)ft.dwHighDateTime) << 32) | ft.dwLowDateTime;

     // A Windows tick is 100 nanoseconds. Windows epoch 1601-01-01T00:00:00Z
     // is 11644473600 seconds before Unix epoch 1970-01-01T00:00:00Z.
     Timestamp timestamp;
     timestamp.set_seconds((INT64) ((ticks / 10000000) - 11644473600LL));
     timestamp.set_nanos((INT32) ((ticks % 10000000) * 100));

 Example 4: Compute Timestamp from Java `System.currentTimeMillis()`.

     long millis = System.currentTimeMillis();

     Timestamp timestamp = Timestamp.newBuilder().setSeconds(millis / 1000)
         .setNanos((int) ((millis % 1000) * 1000000)).build();

 Example 5: Compute Timestamp from Java `Instant.now()`.

     Instant now = Instant.now();

     Timestamp timestamp =
         Timestamp.newBuilder().setSeconds(now.getEpochSecond())
             .setNanos(now.getNano()).build();

 Example 6: Compute Timestamp from current time in Python.

     timestamp = Timestamp()
     timestamp.GetCurrentTime()

 # JSON Mapping

 In JSON format, the Timestamp type is encoded as a string in the
 [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format. That is, the
 format is "{year}-{month}-{day}T{hour}:{min}:{sec}[.{frac_sec}]Z"
 where {year} is always expressed using four digits while {month}, {day},
 {hour}, {min}, and {sec} are zero-padded to two digits each. The fractional
 seconds, which can go up to 9 digits (i.e. up to 1 nanosecond resolution),
 are optional. The "Z" suffix indicates the timezone ("UTC"); the timezone
 is required. A proto3 JSON serializer should always use UTC (as indicated by
 "Z") when printing the Timestamp type and a proto3 JSON parser should be
 able to accept both UTC and other timezones (as indicated by an offset).

 For example, "2017-01-15T01:30:15.01Z" encodes 15.01 seconds past
 01:30 UTC on January 15, 2017.

 In JavaScript, one can convert a Date object to this format using the
 standard
 [toISOString()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString)
 method. In Python, a standard `datetime.datetime` object can be converted
 to this format using
 [`strftime`](https://docs.python.org/2/library/time.html#time.strftime) with
 the time format spec '%Y-%m-%dT%H:%M:%S.%fZ'. Likewise, in Java, one can use
 the Joda Time's [`ISODateTimeFormat.dateTime()`](
 http://joda-time.sourceforge.net/apidocs/org/joda/time/format/ISODateTimeFormat.html#dateTime()
 ) to obtain a formatter capable of generating timestamps in this format.



 

   Represents seconds of UTC time since Unix epoch
 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
 9999-12-31T23:59:59Z inclusive.


  

  

  

  Non-negative fractions of a second at nanosecond resolution. Negative
 second values with fractions must still have non-negative nanos values
 that count forward in time. Must be from 0 to 999,999,999
 inclusive.


 

 

 bproto3 

,awardit/inventory/v1/inventory_service.protoawardit.inventory.v1google/protobuf/timestamp.proto"
	StockItem
sku (	Rsku!
warehouse_id (	RwarehouseId7
	read_time (2.google.protobuf.TimestampRreadTime=
updated_time (2.google.protobuf.TimestampRupdatedTime-
available_quantity (RavailableQuantity"
StockItemFilter
sku (	H Rsku&
warehouse_id (	HRwarehouseIdO
modified_since_time (2.google.protobuf.TimestampHRmodifiedSinceTimeB
_skuB

_warehouse_idB
_modified_since_time"h
StreamStockItemsRequestB
filter (2%.awardit.inventory.v1.StockItemFilterH RfilterB	
_filter"
ListStockItemsRequestB
filter (2%.awardit.inventory.v1.StockItemFilterH Rfilter
	page_size (RpageSize

page_token (	R	pageTokenB	
_filter"w
ListStockItemsResponse5
items (2.awardit.inventory.v1.StockItemRitems&
next_page_token (	R
nextPageToken2
	Inventoryd
StreamStockItems-.awardit.inventory.v1.StreamStockItemsRequest.awardit.inventory.v1.StockItem0k
ListStockItems+.awardit.inventory.v1.ListStockItemsRequest,.awardit.inventory.v1.ListStockItemsResponseB|
com.awardit.grpc.inventory.v1PAwardit.Grpc.Inventory.V1Awardit\Grpc\Inventory\V1 GPBMetadata\Awardit\Inventory\V1J
 K
S
 I Inventory management, including querying inventory status for products.


 
	
  )

 6
	
 6

 "
	

 "

	 6
	
%	 6


 6
	
)
 6

 F
	
, F
5
  ) Service exposing inventory information.



 
D
  L7 Returns a stream of items matching the given filters.


  

  /

  :@

  AJ
Q
 ND Query stock items based on a filter, returning a paginated result.


 

 +

 6L
-
  !! Information about a stock item.



 
P
  C Product SKU/Stock-keeping-unit, globally unique for each product.


  

  	

  
S
 F Which warehouse these items are contained in. UUID in string-format.


 

 	

 
A
 *4 When this stock item was read, UTC per definition.


 

 %

 ()
6
 -) When this stock item was last modified.


 

 (

 +,
'
   Available item quantity.


  

  

  
;
$ // Filter parameters for the StreamItems method.



$
B
 &5 Optional. Product SKU to filter inventory items by.


 &


 &

 &

 &

+# Optional. Warehouse to filter results by. UUID in string-format.

 Note: The available warehouse-ids depend on the permissions granted to the
 client.


+


+

+

+!"
z
.=m Optional. Timestamp to filter results by, will include items created or
 updated after the given timestamp.


.


.$

.%8

.;<
.
2 5" Request for streamed StockItems.



2
?
 4&2 Optional. Filters for the stock items to return.


 4


 4

 4!

 4$%
9
8 A- Filter parameters for the ListItems method.



8
?
 :&2 Optional. Filters for the stock items to return.


 :


 :

 :!

 :$%
7
<* Optional. The page size of the response.


<

<

<
y
@l Optional. Token for which page to return, obtained from next_page_token.

 Leave empty for the first page.


@

@	

@
%
D K Response from ListItems



D
8
 F+ StockItems matching the supplied filters.


 F


 F

 F

 F
^
JQ Optional. Token used to obtain the next page.

 Empty if this is the last page.


J

J	

Jbproto3  
	
awardit/order/common.proto
awardit.order"(
TrackingNumber
number (	Rnumber*
OrderStatus
ORDER_STATUS_UNSPECIFIED 
ORDER_STATUS_ORDERED
ORDER_STATUS_HOLD
ORDER_STATUS_PICKING
ORDER_STATUS_FULFILLED
ORDER_STATUS_CANCELLEDB`
com.awardit.grpc.orderPAwardit.Grpc.OrderAwardit\Grpc\OrderGPBMetadata\Awardit\OrderJ
  
(
 2 Common datatypes for orders.


 

 /
	
 /

 "
	

 "

 /
	
% /

	 .
	
)	 .


 >
	
,
 >
B
 
 6 Status describing the current phase the order is in.



 

$
   Unknown order status.


  

  
&
  Order has been created.


 

 
 
  Order is on-hold.


 

 
,
  Order-items are being picked.


 

 
K
 > Order has been fulfilled (shipped/packaged/pending-sending).


 

 
(
  Order has been cancelled.


 

 
P
   D Tracking number for a parcel which is to be sent or has been sent.



 
,
   Tracking number for a parcel.


  

  	

  bproto3  

$awardit/order/v1/order_service.protoawardit.order.v1google/protobuf/timestamp.protoawardit/order/common.proto"=
 GetOrderStatusInformationRequest
order_id (	RorderId"
OrderStatusInformation
order_id (	RorderId=
order_status (2.awardit.order.OrderStatusRorderStatus=
created_time (2.google.protobuf.TimestampRcreatedTime=
updated_time (2.google.protobuf.TimestampRupdatedTimeH
tracking_numbers (2.awardit.order.TrackingNumberRtrackingNumbers2
Ordery
GetOrderStatusInformation2.awardit.order.v1.GetOrderStatusInformationRequest(.awardit.order.v1.OrderStatusInformationBl
com.awardit.grpc.order.v1PAwardit.Grpc.Order.V1Awardit\Grpc\Order\V1GPBMetadata\Awardit\Order\V1J	
 +
.
 $ Datatypes and services for orders.


 
	
  )
	
 $

 2
	
 2

	 "
	

	 "


 2
	
%
 2

 2
	
) 2

 B
	
, B
<
  0 Service for querying information about orders.



 
G
  %9 Attempts to retrieve the order-status of a given order.


  

   @

  
#
D
  8 Request for querying order status of a specific order.



 (
*
   Required. Order identifier.


  

  	

  
N
 +B The current order status information for the requested order id.




 
  Order identifier.


 

 	

 

 - Order status.


 

 (

 +,
*
"- When the order was created.


"

"(

"+,
/
$-" When the order was last updated.


$

$(

$+,

*= Parcels for the order, will be empty for virtual orders or if the order
 has not yet been picked.

 Some shipping methods do not provide any tracking information or parcel
 data.


*


*'

*(8

*;<bproto3  