// Datatypes and services for orders.

// @generated by protoc-gen-es v1.7.1 with parameter "target=ts"
// @generated from file awardit/order/v1/order_service.proto (package awardit.order.v1, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3, Timestamp } from "@bufbuild/protobuf";
import { OrderStatus, TrackingNumber } from "../common_pb.js";

/**
 * Request for querying order status of a specific order.
 *
 * @generated from message awardit.order.v1.GetOrderStatusInformationRequest
 */
export class GetOrderStatusInformationRequest extends Message<GetOrderStatusInformationRequest> {
  /**
   * Required. Order identifier.
   *
   * @generated from field: string order_id = 1;
   */
  orderId = "";

  constructor(data?: PartialMessage<GetOrderStatusInformationRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "awardit.order.v1.GetOrderStatusInformationRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "order_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetOrderStatusInformationRequest {
    return new GetOrderStatusInformationRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetOrderStatusInformationRequest {
    return new GetOrderStatusInformationRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetOrderStatusInformationRequest {
    return new GetOrderStatusInformationRequest().fromJsonString(jsonString, options);
  }

  static equals(a: GetOrderStatusInformationRequest | PlainMessage<GetOrderStatusInformationRequest> | undefined, b: GetOrderStatusInformationRequest | PlainMessage<GetOrderStatusInformationRequest> | undefined): boolean {
    return proto3.util.equals(GetOrderStatusInformationRequest, a, b);
  }
}

/**
 * The current order status information for the requested order id.
 *
 * @generated from message awardit.order.v1.OrderStatusInformation
 */
export class OrderStatusInformation extends Message<OrderStatusInformation> {
  /**
   * Order identifier.
   *
   * @generated from field: string order_id = 1;
   */
  orderId = "";

  /**
   * Order status.
   *
   * @generated from field: awardit.order.OrderStatus order_status = 2;
   */
  orderStatus = OrderStatus.UNSPECIFIED;

  /**
   * When the order was created.
   *
   * @generated from field: google.protobuf.Timestamp created_time = 3;
   */
  createdTime?: Timestamp;

  /**
   * When the order was last updated.
   *
   * @generated from field: google.protobuf.Timestamp updated_time = 4;
   */
  updatedTime?: Timestamp;

  /**
   * Parcels for the order, will be empty for virtual orders or if the order
   * has not yet been picked.
   *
   * Some shipping methods do not provide any tracking information or parcel
   * data.
   *
   * @generated from field: repeated awardit.order.TrackingNumber tracking_numbers = 5;
   */
  trackingNumbers: TrackingNumber[] = [];

  constructor(data?: PartialMessage<OrderStatusInformation>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "awardit.order.v1.OrderStatusInformation";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "order_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "order_status", kind: "enum", T: proto3.getEnumType(OrderStatus) },
    { no: 3, name: "created_time", kind: "message", T: Timestamp },
    { no: 4, name: "updated_time", kind: "message", T: Timestamp },
    { no: 5, name: "tracking_numbers", kind: "message", T: TrackingNumber, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): OrderStatusInformation {
    return new OrderStatusInformation().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): OrderStatusInformation {
    return new OrderStatusInformation().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): OrderStatusInformation {
    return new OrderStatusInformation().fromJsonString(jsonString, options);
  }

  static equals(a: OrderStatusInformation | PlainMessage<OrderStatusInformation> | undefined, b: OrderStatusInformation | PlainMessage<OrderStatusInformation> | undefined): boolean {
    return proto3.util.equals(OrderStatusInformation, a, b);
  }
}

