// Inventory management, including querying inventory status for products.

// @generated by protoc-gen-es v1.7.1 with parameter "target=ts"
// @generated from file awardit/inventory/v1/inventory_service.proto (package awardit.inventory.v1, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3, protoInt64, Timestamp } from "@bufbuild/protobuf";

/**
 * Information about a stock item.
 *
 * @generated from message awardit.inventory.v1.StockItem
 */
export class StockItem extends Message<StockItem> {
  /**
   * Product SKU/Stock-keeping-unit, globally unique for each product.
   *
   * @generated from field: string sku = 1;
   */
  sku = "";

  /**
   * Which warehouse these items are contained in. UUID in string-format.
   *
   * @generated from field: string warehouse_id = 2;
   */
  warehouseId = "";

  /**
   * When this stock item was read, UTC per definition.
   *
   * @generated from field: google.protobuf.Timestamp read_time = 3;
   */
  readTime?: Timestamp;

  /**
   * When this stock item was last modified.
   *
   * @generated from field: google.protobuf.Timestamp updated_time = 4;
   */
  updatedTime?: Timestamp;

  /**
   * Available item quantity.
   *
   * @generated from field: int64 available_quantity = 5;
   */
  availableQuantity = protoInt64.zero;

  constructor(data?: PartialMessage<StockItem>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "awardit.inventory.v1.StockItem";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "sku", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "warehouse_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "read_time", kind: "message", T: Timestamp },
    { no: 4, name: "updated_time", kind: "message", T: Timestamp },
    { no: 5, name: "available_quantity", kind: "scalar", T: 3 /* ScalarType.INT64 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StockItem {
    return new StockItem().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StockItem {
    return new StockItem().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StockItem {
    return new StockItem().fromJsonString(jsonString, options);
  }

  static equals(a: StockItem | PlainMessage<StockItem> | undefined, b: StockItem | PlainMessage<StockItem> | undefined): boolean {
    return proto3.util.equals(StockItem, a, b);
  }
}

/**
 * Filter parameters for the StreamItems method.
 *
 * @generated from message awardit.inventory.v1.StockItemFilter
 */
export class StockItemFilter extends Message<StockItemFilter> {
  /**
   * Optional. Product SKU to filter inventory items by.
   *
   * @generated from field: optional string sku = 1;
   */
  sku?: string;

  /**
   * Optional. Warehouse to filter results by. UUID in string-format.
   *
   * Note: The available warehouse-ids depend on the permissions granted to the
   * client.
   *
   * @generated from field: optional string warehouse_id = 2;
   */
  warehouseId?: string;

  /**
   * Optional. Timestamp to filter results by, will include items created or
   * updated after the given timestamp.
   *
   * @generated from field: optional google.protobuf.Timestamp modified_since_time = 3;
   */
  modifiedSinceTime?: Timestamp;

  constructor(data?: PartialMessage<StockItemFilter>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "awardit.inventory.v1.StockItemFilter";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "sku", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "warehouse_id", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "modified_since_time", kind: "message", T: Timestamp, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StockItemFilter {
    return new StockItemFilter().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StockItemFilter {
    return new StockItemFilter().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StockItemFilter {
    return new StockItemFilter().fromJsonString(jsonString, options);
  }

  static equals(a: StockItemFilter | PlainMessage<StockItemFilter> | undefined, b: StockItemFilter | PlainMessage<StockItemFilter> | undefined): boolean {
    return proto3.util.equals(StockItemFilter, a, b);
  }
}

/**
 * Request for streamed StockItems.
 *
 * @generated from message awardit.inventory.v1.StreamStockItemsRequest
 */
export class StreamStockItemsRequest extends Message<StreamStockItemsRequest> {
  /**
   * Optional. Filters for the stock items to return.
   *
   * @generated from field: optional awardit.inventory.v1.StockItemFilter filter = 1;
   */
  filter?: StockItemFilter;

  constructor(data?: PartialMessage<StreamStockItemsRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "awardit.inventory.v1.StreamStockItemsRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "filter", kind: "message", T: StockItemFilter, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StreamStockItemsRequest {
    return new StreamStockItemsRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StreamStockItemsRequest {
    return new StreamStockItemsRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StreamStockItemsRequest {
    return new StreamStockItemsRequest().fromJsonString(jsonString, options);
  }

  static equals(a: StreamStockItemsRequest | PlainMessage<StreamStockItemsRequest> | undefined, b: StreamStockItemsRequest | PlainMessage<StreamStockItemsRequest> | undefined): boolean {
    return proto3.util.equals(StreamStockItemsRequest, a, b);
  }
}

/**
 * Filter parameters for the ListItems method.
 *
 * @generated from message awardit.inventory.v1.ListStockItemsRequest
 */
export class ListStockItemsRequest extends Message<ListStockItemsRequest> {
  /**
   * Optional. Filters for the stock items to return.
   *
   * @generated from field: optional awardit.inventory.v1.StockItemFilter filter = 1;
   */
  filter?: StockItemFilter;

  /**
   * Optional. The page size of the response.
   *
   * @generated from field: int32 page_size = 2;
   */
  pageSize = 0;

  /**
   * Optional. Token for which page to return, obtained from next_page_token.
   *
   * Leave empty for the first page.
   *
   * @generated from field: string page_token = 3;
   */
  pageToken = "";

  constructor(data?: PartialMessage<ListStockItemsRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "awardit.inventory.v1.ListStockItemsRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "filter", kind: "message", T: StockItemFilter, opt: true },
    { no: 2, name: "page_size", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 3, name: "page_token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListStockItemsRequest {
    return new ListStockItemsRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListStockItemsRequest {
    return new ListStockItemsRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListStockItemsRequest {
    return new ListStockItemsRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ListStockItemsRequest | PlainMessage<ListStockItemsRequest> | undefined, b: ListStockItemsRequest | PlainMessage<ListStockItemsRequest> | undefined): boolean {
    return proto3.util.equals(ListStockItemsRequest, a, b);
  }
}

/**
 * Response from ListItems
 *
 * @generated from message awardit.inventory.v1.ListStockItemsResponse
 */
export class ListStockItemsResponse extends Message<ListStockItemsResponse> {
  /**
   * StockItems matching the supplied filters.
   *
   * @generated from field: repeated awardit.inventory.v1.StockItem items = 1;
   */
  items: StockItem[] = [];

  /**
   * Optional. Token used to obtain the next page.
   *
   * Empty if this is the last page.
   *
   * @generated from field: string next_page_token = 2;
   */
  nextPageToken = "";

  constructor(data?: PartialMessage<ListStockItemsResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "awardit.inventory.v1.ListStockItemsResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "items", kind: "message", T: StockItem, repeated: true },
    { no: 2, name: "next_page_token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListStockItemsResponse {
    return new ListStockItemsResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListStockItemsResponse {
    return new ListStockItemsResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListStockItemsResponse {
    return new ListStockItemsResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ListStockItemsResponse | PlainMessage<ListStockItemsResponse> | undefined, b: ListStockItemsResponse | PlainMessage<ListStockItemsResponse> | undefined): boolean {
    return proto3.util.equals(ListStockItemsResponse, a, b);
  }
}

