<?php

class Awardit_GoogleMerchant_ProductsController extends Mage_Core_Controller_Front_Action
{
    public function hasAction($action): bool
    {
        return true; // Always handle internally
    }

    public function norouteAction($coreRoute = null): void
    {
        $request = $this->getRequest();
        $response = $this->getResponse();

        $path = array_values(array_filter(explode('/', $request->getPathInfo())));
        if (count($path) <= 2) {
            $response->setHttpResponseCode(400)->setBody("Bad Request: No store code specified");
            return;
        }

        try {
            $store = Mage::app()->getStore($path[2]);
        } catch (Throwable $t) {
            $response->setHttpResponseCode(404)->setBody("Not found: {$t->getMessage()}");
            return;
        }

        try {
            $feed = new Awardit\GoogleMerchant\Feed\Products($store);
            $format = $request->getQuery('format', 'csv');
            $this->getResponse()->setBody($feed->render($format));
        } catch (Throwable $t) {
            $response->setHttpResponseCode(400)->setBody("Bad Request: {$t->getMessage()}");
        }
    }
}
