<?php

namespace Awardit\GoogleMerchant\Cli;

use Mage;
use Mage_Core_Model_Resource_Store_Collection;
use Awardit\GoogleMerchant\Feed\Products as FeedProducts;

class Products
{
    private ?Mage_Core_Model_Resource_Store_Collection $stores = null;

    public function __construct()
    {
        $this->stores = Mage::getModel('core/store')->getCollection();
    }

    public function fillCache(): void
    {
        Mage::log('[Google Merchant Feed]: fill cache started');
        if (empty($this->stores)) {
            Mage::log('[Google Merchant Feed]: no stores found');
            return;
        }

        $cache = Mage::app()->getCacheInstance();

        foreach ($this->stores as $store) {
            Mage::log("[Google Merchant Feed]: {$store->getName()} - started");
            $feed = new FeedProducts($store);
            $products = $feed->fetchProducts();
            // Store result in cache
            $cache_key = FeedProducts::CACHE_PREFIX . $store->getId();
            $cache->save(json_encode($products), $cache_key, [], FeedProducts::CACHE_LIFETIME);
            Mage::log("[Google Merchant Feed]: {$store->getName()} - completed");
        }
        Mage::log('[Google Merchant Feed]: fill cache ended');
    }
}
