<?php
declare(strict_types=1);

class Awardit_FreeShippingCalculator_Model_Schema extends MageQL_Core_Model_Schema_Abstract
{
    /**
     * Get the type builder for this schema
     *
     * @param string $typeName
     * @param MageQL\Registry $registry
     * @return MageQL\Type\AbstractBuilder|null
     */
    public function getTypeBuilder(string $typeName, MageQL\Registry $registry): ?MageQL\Type\AbstractBuilder
    {
        return null; // Return null if no custom type builder is needed
    }

    public function getTypeFields(string $typeName, MageQL\Registry $registry): array
    {
        if ($typeName === 'QuoteShipping') {
            return [
                'freeShippingThreshold' => $this->field('Float', 'Free shipping threshold amount')
                    ->setResolver([get_class(), 'resolveFreeShippingThreshold']),
                'freeShippingAmountNeeded' => $this->field('Float', 'Amount needed to qualify for free shipping')
                    ->setResolver([get_class(), 'resolveFreeShippingAmountNeeded']),
                'isEligibleForFreeShipping' => $this->field('Boolean', 'Whether the quote is eligible for free shipping')
                    ->setResolver([get_class(), 'resolveIsEligibleForFreeShipping']),
            ];
        }

        return [];
    }

    public static function resolveFreeShippingThreshold($src): ?float
    {
        $quote = $src->getQuote();
        $helper = Mage::helper('awardit_freeshippingcalculator');
        return $helper->getFreeShippingThresholdFromRules($quote->getStoreId());
    }

    public static function resolveFreeShippingAmountNeeded($src): ?float
    {
        $quote = $src->getQuote();
        $helper = Mage::helper('awardit_freeshippingcalculator');
        return $helper->getAmountNeededForFreeShipping($quote, $quote->getStoreId());
    }

    public static function resolveIsEligibleForFreeShipping($src): bool
    {
        $quote = $src->getQuote();
        $helper = Mage::helper('awardit_freeshippingcalculator');
        return $helper->isEligibleForFreeShipping($quote);
    }
}