<?php
declare(strict_types=1);

class Awardit_FreeShippingCalculator_Model_Calculator extends Mage_Core_Model_Abstract
{
    protected $_helper;

    protected function _construct()
    {
        $this->_helper = Mage::helper('awardit_freeshippingcalculator');
    }

    public function calculateForQuote($quote)
    {
        if (!$quote || !$quote->getId()) {
            return array(
                'eligible' => false,
                'amount_needed' => null,
                'threshold' => null,
                'current_subtotal' => 0,
                'message' => null
            );
        }

        $currentSubtotal = (float) $quote->getSubtotal();
        $threshold = $this->_helper->getFreeShippingThresholdFromRules($quote->getStoreId());
        $amountNeeded = $this->_helper->getAmountNeededForFreeShipping($quote, $quote->getStoreId());
        $eligible = $this->_helper->isEligibleForFreeShipping($quote);

        $message = null;
        if ($threshold !== null) {
            $message = $this->_helper->formatAmountNeeded($amountNeeded, $quote->getStoreId());
        }

        return array(
            'eligible' => $eligible,
            'amount_needed' => $amountNeeded,
            'threshold' => $threshold,
            'current_subtotal' => $currentSubtotal,
            'message' => $message
        );
    }

    public function calculateForCurrentCart()
    {
        $quote = Mage::getSingleton('checkout/session')->getQuote();
        return $this->calculateForQuote($quote);
    }

    public function getAvailableFreeShippingRules($storeId = null)
    {
        $websiteId = Mage::app()->getStore($storeId)->getWebsiteId();
        $customerGroupId = Mage::getSingleton('customer/session')->getCustomerGroupId();
        $now = Mage::getModel('core/date')->date('Y-m-d');

        $rules = Mage::getModel('salesrule/rule')->getCollection()
            ->addFieldToFilter('is_active', 1)
            ->addFieldToFilter('simple_free_shipping', array('neq' => 0))
            ->addWebsiteFilter($websiteId)
            ->addCustomerGroupFilter($customerGroupId)
            ->addDateFilter($now);

        $result = array();
        foreach ($rules as $rule) {
            $threshold = $this->_helper->extractSubtotalThresholdFromRule($rule);
            if ($threshold !== null) {
                $result[] = array(
                    'rule_id' => $rule->getId(),
                    'rule_name' => $rule->getName(),
                    'threshold' => $threshold,
                    'description' => $rule->getDescription()
                );
            }
        }

        usort($result, function($a, $b) {
            return $a['threshold'] <=> $b['threshold'];
        });

        return $result;
    }
}