# Awardit Free Shipping Calculator

A Magento 1 module that calculates how much more money a customer needs to add to their basket to qualify for free shipping based on Shopping Cart Price Rules.

## Features

- Calculates the minimum amount needed to reach free shipping threshold
- Works with Magento Shopping Cart Price Rules that offer free shipping
- Supports multiple free shipping rules (returns the lowest threshold)
- Provides formatted messages for display to customers
- Includes helper methods for easy integration
- Shipping rule must be called Free Shipping

## Installation

1. Navigate to your project root and run:
```bash
cd FreeShippingCalculator
composer install
```

2. The module will be automatically installed into your Magento installation via composer.

## Usage

### Basic Usage

```php
// Get the helper
// FREE SHIPPING CALCULATOR - Using the Fixed Module
$freeShippingHelper = Mage::helper('awardit_freeshippingcalculator');
$freeShippingCalculator = Mage::getModel('awardit_freeshippingcalculator/calculator');

// Get the calculation result for current cart
$freeShippingResult = $freeShippingCalculator->calculateForCurrentCart();

// Get amount needed and threshold using the fixed helper methods
$amountNeeded = $freeShippingHelper->getAmountNeededForFreeShipping();
$threshold = $freeShippingHelper->getFreeShippingThresholdFromRules();
```
