<?php

/**
 * @psalm-scope-this Mage_Catalog_Model_Resource_Setup
 */
$installer = $this;
$installer->startSetup();
$attributeName = "Donations";
$attributeSet = $installer->getAttributeSet(Mage_Catalog_Model_Product::ENTITY, $attributeName);

if( ! $attributeSet) {
    $installer->addAttributeSet(Mage_Catalog_Model_Product::ENTITY, $attributeName);
}

$installer->addAttribute(Mage_Catalog_Model_Product::ENTITY, "donation_message", [
    "group"            => "General",
    "label"            => "Donation message",
    "type"             => "text",
    "input"            => "text",
    "required"         => false,
    "visible_on_front" => false,
    "used_in_product_listing" => false,
    "filterable"       => false,
    "searchable"       => false,
    "comparable"       => false,
    "user_defined"     => true,
    "default"          => 0,
    "is_configurable"  => false,
    // Hide in admin
    "visible"          => true,
    "global"           => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    "note"             => "Message which is shown in the email sent to the donor",
    "position"         => 2,
]);
$installer->endSetup();

