<?php

namespace Points\Core;

use Fixtures\Customer;
use Fixtures\Products;
use Fixtures\TaxRates;

use Crossroads\Magento\Test\Integration\MagentoManager;
use Mage;
use Mage_Catalog_Model_Product;
use Mage_Catalog_Model_Product_Status;
use Mage_Catalog_Model_Product_Visibility;

require_once __DIR__."/../vendor/autoload.php";
require_once __DIR__."/../vendor/crossroads/mageql/test/Fixtures/Customer.php";
require_once __DIR__."/../vendor/crossroads/mageql-catalog/test/Fixtures/Products.php";
require_once __DIR__."/../vendor/crossroads/mageql-catalog/test/Fixtures/TaxRates.php";

MagentoManager::setUp(__DIR__."/../vendor/awardit/magento-lts");

(new Customer())->load();
(new TaxRates())->load();

$product = new Products();
$product->load();
MagentoManager::initAdmin();
$store = Mage::app()->getStore(MagentoManager::TESTING_STORE);
$manufacturer = $product->getAttributeValue("manufacturer", "Manufacturer A");
$attributeSetId = Mage::getSingleton("catalog/config")->getAttributeSetId(Mage_Catalog_Model_Product::ENTITY,"Donations");

$template = Mage::getModel("core/email_template");
$template->loadByCode("test_donation_email");
$template->addData([
    "template_code" => "test_donation_email",
    "template_text" => "message: {{var donationMessage}}\ncustomer: {{var customerFirstname}} {{var customerLastname}}\nemail: {{var customerEmail}}",
    "template_subject" => "Test"
]);
$template->save();

$product->loadOrCreate([
    "store_id" => $store->getId(),
    "website_ids" => [$store->getWebsiteId()],
    "type_id" => "virtual",
    "attribute_set_id" => $attributeSetId,
    "sku" => "test-donation",
    "name" => "Test for Donation Product",
    "manufacturer" => $manufacturer,
    "status" => Mage_Catalog_Model_Product_Status::STATUS_ENABLED,
    "tax_class_id" => TaxRates::getTaxClass(TaxRates::PRODUCT_TAX_CLASS)->getId(),
    "visibility" => Mage_Catalog_Model_Product_Visibility::VISIBILITY_BOTH,
    "price" => 12.34,
    "meta_title" => "Product meta title",
    "meta_description" => "Product meta description",
    "meta_keyword" => "Product,meta,keywords",
    "description" => "The long product description",
    "short_description" => "The shortest product description",
    "weight" => 3.14,
    "small_image" => "product_small_image.jpg",
    "small_image_label" => "Small Product Image",
    "thumbnail" => "product_thumbnail.jpg",
    "thumbnail_label" => "Thumbnail Product Image",
    "media_gallery" => [
        "images" => [
            ["file" => "first_gallery.jpg", "position" => 0, "label" => "First Gallery", "disabled" => 0],
            ["file" => "second_gallery.jpg", "position" => 1, "label" => "Second Gallery", "disabled" => 0],
            ["file" => "disabled_gallery.jpg", "position" => 2, "label" => "Disabled Gallery", "disabled" => 1],
        ],
    ],
    "is_featured" => "1",
    "donation_message" => "Tack för din donation på X poäng till välgörenhetsändamål Djurens rätt"
]);
MagentoManager::reindex();
MagentoManager::reset();

