<?php

declare(strict_types=1);

use MageQL\ClientException;

class Awardit_CodeLock_InvalidCodeException
    extends ClientException {
    public function __construct(string $source) {
        parent::__construct("Invalid code supplied in $source");
    }

    /**
     * @return bool
     */
    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "codelock";
    }

    public function getExtensions(): array {
        return [
            "code" => "codelock_code_invalid",
        ];
    }
}
