<?php

declare(strict_types=1);

use MageQL\ClientException;

class Awardit_CodeLock_EmptyCodeException
    extends ClientException {
    public function __construct() {
        parent::__construct("No code supplied in either X-Codelock-Code header or codelock_code query parameter");
    }

    /**
     * @return bool
     */
    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "codelock";
    }

    public function getExtensions(): array {
        return [
            "code" => "codelock_code_empty",
        ];
    }
}
