<?php

declare(strict_types=1);

/**
 * @method int getEntityId()
 * @method int getStoreId()
 * @method void setStoreId(int $id)
 * @method string getCode()
 * @method void setCode(string $code)
 * @method bool getActive()
 * @method void setActive(bool $code)
 * @method ?int getCustomerGroupId()
 * @method void setCustomerGroupId(?int $id)
 * @method string getCreatedAt()
 * @method string getUpdatedAt()
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_CodeLock_Model_Code extends Mage_Core_Model_Abstract {
    public function _construct(): void {
        parent::_construct();

        $this->_init("codelock/code");
    }

    /**
     * @return $this
     */
    public function loadByCode(Mage_Core_Model_Store $store, string $code) {
        /**
         * @var Awardit_CodeLock_Model_Resource_Code
         */
        $resource = $this->_getResource();

        $resource->loadByCode($this, $store, $code);

        return $this;
    }

    protected function _beforeSave() {
        parent::_beforeSave();

        $this->setData("updated_at", date("Y-m-d\\TG:i:s"));

        return $this;
    }
}
