<?php

declare(strict_types=1);

use MageQL\Context;

class Awardit_CodeLock_Model_Observer {
    public function salesQuoteCollectTotalsBefore(Varien_Event_Observer $observer): void {
        /**
         * @var Awardit_CodeLock_QuoteExtension
         */
        $quote = $observer->getQuote();

        if ($quote->getCodelockId()) {
            return;
        }

        /** @var Awardit_CodeLock_Model_Session */
        $session = Mage::getSingleton("codelock/session");
        $code = $session->getCode();
        $commission = $session->getCommission();

        if($code && $code->getStoreId() == $quote->getStoreId()) {
            $quote->setCodelockId((int)$code->getId());
        }
        else {
            $quote->setCodelockId(null);
        }

        if($commission) {
            $quote->setCodelockCommission($commission);
        }
    }

    public function mageqlCoreContextAfter(Varien_Event_Observer $observer): void {
        /**
         * @var Context
         */
        $context = $observer->getContext();
        $store = $context->getStore();
        /** @var Awardit_CodeLock_Helper_Data */
        $helper = Mage::helper("codelock");

        if( ! $helper->isEnabled($store)) {
            return;
        }

        $request = Mage::app()->getRequest();
        /** @var Awardit_CodeLock_Model_Session */
        $session = Mage::getSingleton("codelock/session");
        $customerSession = Mage::getSingleton("customer/session");
        $code = $session->getCode();

        if($code && $code->getStoreId() == $store->getId()) {
            // We have a code, continue
            return;
        }

        $codeString = $request->getQuery("codelock_code") ?: $request->getHeader("X-Codelock-Code");
        $commission = $request->getQuery("sp") ?: $request->getHeader("X-Codelock-Commission");

        if(empty($codeString)) {
            throw new Awardit_CodeLock_EmptyCodeException();
        }

        /** @var Awardit_CodeLock_Model_Code */
        $code = Mage::getModel("codelock/code");

        $code->loadByCode($store, $codeString);

        if( ! $code->getId()) {
            throw new Awardit_CodeLock_InvalidCodeException(
                empty($request->getQuery("codelock_code")) ? "X-Codelock-Code header" : "codelock_code query parameter"
            );
        }

        $session->setCode($code);
        $session->setCommission($commission);
        $customerGroupId = $code->getCustomerGroupId();

        if( ! is_null($customerGroupId)) {
            $customerSession->setCustomerGroupId($customerGroupId);
        }
    }
}
