<?php

declare(strict_types=1);

class Awardit_CodeLock_Model_Session extends Mage_Core_Model_Session_Abstract {
    /**
     * @var ?Awardit_CodeLock_Model_Code
     */
    protected $codeLock = null;

    public function __construct() {
        $this->init("codelock");
    }

    /**
     * @return $this
     */
    public function setCode(Awardit_CodeLock_Model_Code $code) {
        $this->codelock = $code;

        $this->setData("codelock_id", $code->getId());

        return $this;
    }

    /**
     * @param mixed $commission
     * @return $this
     */
    public function setCommission($commission = false) {
        $this->setData("codelock_commission", boolval($commission));
        return $this;
    }

    public function getCode(): ?Awardit_CodeLock_Model_Code {
        if( ! $this->codelock) {
            $id = $this->getData("codelock_id");

            if($id) {
                $code = Mage::getModel("codelock/code");

                $code->load($id);

                if($code->getId() && $code->getActive()) {
                    $this->codelock = $code;
                }
                else {
                    $this->setData("codelock_id", null);
                }
            }
        }

        return $this->codelock;
    }

    public function getCommission(): bool {
        return $this->getData("codelock_commission") ?? false;
    }
}
