<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$tableName = $installer->getTable("codelock/code");

$table = $conn->newTable($tableName);

$table->addColumn("entity_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "identity" => true,
    "unsigned" => true,
    "nullable" => false,
    "primary" => true,
], "Entity id");
$table->addColumn("store_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
    "unsigned" => true,
    "nullable" => false,
    "default" => "0",
], "Store id this code is used in.");
$table->addColumn("code", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
    "nullable" => false,
]);
$table->addColumn("active", Varien_Db_Ddl_Table::TYPE_BOOLEAN, null, [
    "nullable" => false,
    "default" => true,
]);
$table->addColumn("customer_group_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
    "nullable" => true,
    "unsigned" => true,
]);
$table->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
    "nullable" => false,
    "default" => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
]);
$table->addColumn("updated_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
    "nullable" => false,
    "default" => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
]);

$table->addIndex(
    $installer->getIdxName("codelock/code", ["store_id", "code"], Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE),
    ["store_id", "code"],
    [ "type" => Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE ]
);
$table->addForeignKey(
    $installer->getFkName("codelock/code", "store_id", "core/store", "store_id"),
    "store_id",
    $installer->getTable("core/store"),
    "store_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE,
    Varien_Db_Ddl_Table::ACTION_CASCADE
);

$table->setOption("type", "InnoDB");
$table->setOption("charset", "utf8");

// If we have a local crossroads_codelock installed, table already exists.
if (!$conn->isTableExists($tableName)) {
    $conn->createTable($table);
}

$codelockId = [
    "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
    "nullable" => true,
    "unsigned" => false,
    "comment" => "Code lock id",
];

foreach(["sales/quote", "sales/order"] as $t) {
    $conn->addColumn($this->getTable($t), "codelock_id", $codelockId);

    $conn->addConstraint(
        $installer->getFkName($t, "codelock_id", "codelock/code", "entity_id"),
        $installer->getTable($t),
        "codelock_id",
        $installer->getTable("codelock/code"),
        "entity_id",
        Varien_Db_Ddl_Table::ACTION_SET_NULL,
        Varien_Db_Ddl_Table::ACTION_SET_NULL
    );
}

$installer->endSetup();
