<?php

declare(strict_types=1);

use MageQL\Context;

class Awardit_CodeLock_Model_Observer {
    public function salesQuoteCollectTotalsBefore(Varien_Event_Observer $observer): void {
        /**
         * @var Awardit_CodeLock_QuoteExtension
         */
        $quote = $observer->getQuote();
        $session = Mage::getSingleton("codelock/session");
        $code = $session->getCode();

        if($code && $code->getStoreId() == $quote->getStoreId()) {
            $quote->setCodelockId($code->getId());
        }
        else {
            $quote->setCodelockId(null);
        }
    }

    public function mageqlCoreContextAfter(Varien_Event_Observer $observer): void {
        /**
         * @var Context
         */
        $context = $observer->getContext();
        $store = $context->getStore();
        $helper = Mage::helper("codelock");

        if( ! $helper->isEnabled($store)) {
            return;
        }

        $request = Mage::app()->getRequest();
        $session = Mage::getSingleton("codelock/session");
        $customerSession = Mage::getSingleton("customer/session");
        $code = $session->getCode();

        if($code && $code->getStoreId() == $store->getId()) {
            // We have a code, continue
            return;
        }

        $codeString = $request->getQuery("codelock_code") ?: $request->getHeader("X-Codelock-Code");

        if(empty($codeString)) {
            throw new Awardit_CodeLock_EmptyCodeException();
        }

        $code = Mage::getModel("codelock/code");

        $code->loadByCode($store, $codeString);

        if( ! $code->getId()) {
            throw new Awardit_CodeLock_InvalidCodeException(
                empty($request->getQuery("codelock_code")) ? "X-Codelock-Code header" : "codelock_code query parameter"
            );
        }

        $session->setCode($code);
        $customerGroupId = $code->getCustomerGroupId();

        if( ! is_null($customerGroupId)) {
            $customerSession->setCustomerGroupId($customerGroupId);
        }
    }
}
