<?php

namespace Fixtures;

use Mage;
use Mage_Core_Model_Config;
use Crossroads\Magento\Test\Integration\MagentoManager;
use Awardit_CodeLock_Helper_Data;
use Awardit_CodeLock_Model_Code;
use Mage_Core_Model_Store;

class Codes {
    public function load(): void {
        MagentoManager::initAdmin();

        $this->enableCodelock();
        $this->loadOrCreate([
            'store_id' => 1,
            'code' => 'letmein',
            'active' => 1,
        ]);
        $this->loadOrCreate([
            'store_id' => 1,
            'code' => 'letmeinagain',
            'active' => 1,
        ]);

        MagentoManager::reset();
    }

    public function enableCodeLock(): void {
        $config = new Mage_Core_Model_Config();
        $config->saveConfig(Awardit_CodeLock_Helper_Data::CONFIG_ENABLED, '1', 'default', 0);
    }

    public function loadOrCreate(array $data): void {
        /** @var Awardit_CodeLock_Model_Code */
        $model = Mage::getModel('codelock/code');
        /** @var Mage_Core_Model_Store */
        $store = Mage::app()->getStore(1);

        if ($entityId = $model->loadByCode($store, $data['code'])->getId()) {
            $model->load($entityId);
        }

        $model->addData($data);
        $model->save();
    }
}