<?php

declare(strict_types=1);

class Awardit_CodeLock_Model_Resource_Code extends Mage_Core_Model_Resource_Db_Abstract {
    protected function _construct(): void {
        $this->_init("codelock/code", "entity_id");
    }

    public function loadByCode(
        Awardit_CodeLock_Model_Code $codelock,
        Mage_Core_Model_Store $store,
        string $code
    ): void {
        $adapter = $this->_getReadAdapter();
        $bind = [
            "store_id" => $store->getId(),
            "code" => $code,
        ];

        $select = $adapter->select()
            ->from($this->getTable("codelock/code"), ["entity_id"])
            ->where("store_id = :store_id")
            ->where("code = :code");

        $entityId = $adapter->fetchOne($select, $bind);

        if($entityId) {
            $this->load($codelock, $entityId);
        }
        else {
            $codelock->setData([]);
        }
    }
}
