<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$codelockSource = [
    "type" => Varien_Db_Ddl_Table::TYPE_TEXT,
    "length" => 255,
    "nullable" => false,
    "default" => "",
    "comment" => "Code lock source",
];

foreach(["sales/quote", "sales/order"] as $t) {
    $conn->addColumn($this->getTable($t), "codelock_source", $codelockSource);
}

$installer->endSetup();
