<?php

$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$table = $conn->newTable($installer->getTable("awardit/company"))
    ->addColumn("entity_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "auto_increment" => true,
        "identity"       => true,
        "nullable"       => false,
        "primary"        => true,
        "unsigned"       => true,
    ])
    ->addColumn("enabled", Varien_Db_Ddl_Table::TYPE_BOOLEAN, null, [
        "nullable" => false,
        "default"  => false,
    ])
    ->addColumn("name", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => false,
    ])
    ->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addColumn("deleted_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => true,
        "default"  => null,
    ])
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");

$conn->createTable($table);

$table = $conn->newTable($installer->getTable("awardit/token"))
    ->addColumn("token", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => false,
        "primary"  => true,
    ])
    ->addColumn("company_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned" => true,
        "nullable" => false,
    ])
    ->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addColumn("deleted_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => true,
        "default"  => null,
    ])
    ->addForeignKey(
        $installer->getFkName(
            "awardit/token", "company_id",
            "awardit/company", "entity_id"
        ),
        "company_id", $installer->getTable("awardit/company"), "entity_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");

$conn->createTable($table);

$installer->endSetup();
