<?php

class Awardit_Adminhtml_Block_CatalogProductGrid extends Awardit_Integration_Block_Override_AdminhtmlCatalogProductGrid
{
    /**
     * set collection object
     *
     * @param Varien_Data_Collection $collection
     */
    //public function setCollection(Varien_Data_Collection $collection)
    public function setCollection($collection)
    {
        // Add manufacturer to select
        $collection->addAttributeToSelect('manufacturer');

        $this->_collection = $collection;
    }

    protected function _prepareColumns()
    {
        // Setup all default columns
        parent::_prepareColumns();

        // Get all manufacturers
        $config = Mage::getSingleton("eav/config");
        $attribute = $config->getAttribute(Mage_Catalog_Model_Product::ENTITY, "manufacturer");
        $source = $attribute->getSource();
        $manufacturers = $source->getAllOptions();

        // Transform into options array
        $options = array();
        foreach ($manufacturers as $row) {
            if (empty($row['value'])) { continue; }

            $options[$row['value']] = $row['label'];
        }

        // Add new column
        $this->addColumnAfter(
            'manufacturer',
            array(
                'header' => Mage::helper('catalog')->__('Manufacturer'),
                'index'  => 'manufacturer',
                'type'   => 'options',
                'options'=> $options,
            ),
            'name'
        );

        $this->sortColumnsByOrder();
        return $this;
    }
}