<?php

class Crossroads_Awardit_Model_Method_Token extends Mage_Payment_Model_Method_Abstract {
    protected $_code          = "awardit_token";
    protected $_isOnline      = true;
    protected $_canAuthorize  = true;
    protected $_canCapture    = true;
    protected $_canCancel     = true;
    protected $_canVoid       = true;
    protected $_infoBlockType = "awardit/info_invoice";

    public function isAvailable($quote = null) {
        $request = Mage::app()->getRequest();

        try {
            return Mage::helper("awardit")->getToken($request) && parent::isAvailable($quote);
        }
        catch(Exception $_e) {
            if($quote) {
                return $quote->getAdditionalInformation(Crossroads_Awardit_Helper_Data::FIELD_TOKEN) && parent::isAvailable($quote);
            }

            return parent::isAvailable();
        }
    }

    public function assignData($data) {
        $request = Mage::app()->getRequest();
        $token   = Mage::helper("awardit")->getToken($request);

        if($token) {
            $this->getInfoInstance()->setAdditionalInformation(Crossroads_Awardit_Helper_Data::FIELD_TOKEN, $token->getToken());
            $this->getInfoInstance()->setAdditionalInformation(Crossroads_Awardit_Helper_Data::FIELD_COMPANY_ID, $token->getCompanyId());
        }

        return parent::assignData($data);
    }

    public function authorize(Varien_Object $payment, $amount) {
        $token     = $payment->getAdditionalInformation(Crossroads_Awardit_Helper_Data::FIELD_TOKEN);
        $companyId = $payment->getAdditionalInformation(Crossroads_Awardit_Helper_Data::FIELD_COMPANY_ID);

        if( ! $token || ! $companyId) {
            throw new Exception("Crossroads_Awardit: Attempting to perform purchase without valid key.");
        }

        return $this;
    }

    // Force magento to run authorize no matter what
    public function getConfigPaymentAction() {
        return Mage_Payment_Model_Method_Abstract::ACTION_AUTHORIZE;
    }

    public function capture(Varien_Object $payment, $amount) {
        // Intentionally left empty, allow all payments since it is already authorized
        return $this;
    }

    public function cancel(Varien_Object $payment) {
        // Nothing to do when cancelling, codes should be reset manually
        return $this;
    }

    public function void(Varien_Object $payment) {
        return $this->cancel($payment);
    }
}
