<?php

class Crossroads_Awardit_Helper_Data extends Mage_Core_Helper_Abstract {
    const FIELD_TOKEN      = "crossroads_awardit_token";
    const FIELD_COMPANY_ID = "crossroads_awardit_company_id";
    const PRODUCT_PROPS_EXCLUDE = [
        "customOptions",
        "discountPercent",
        "isPercent",
        "metaDescription",
        "originalPrice",
        "position",
        "relatedProducts",
        "selections",
        "specialPrice",
        "stockBackorders",
        "urlKey",
        "useAsDefault",
    ];

    public function getRequestToken($request) {
        $parts = array_filter(array_map("trim", explode(" ", $request->getHeader("Authorization") ?: "")));

        if(count($parts) !== 2 || strcasecmp($parts[0], "Bearer") !== 0) {
            throw Crossroads_API_ResponseException::create(400, "Invalid Authorization value.", null, 0);
        }

        return $parts[1];
    }

    public function getToken($request) {
        $token = Mage::getModel("awardit/token")->load($this->getRequestToken($request));

        if( ! $token || ! $token->getToken() || ! $token->getEnabled() || $token->getDeletedAt()) {
            throw Crossroads_API_ResponseException::create(400, "Invalid Authorization value.", null, 0);
        }

        return $token;
    }
}
