<?php
$installer = $this;
$installer->startSetup();
$setup = Mage::getResourceModel("catalog/setup", "catalog_setup");

// Add product attributes
$newAttributes = [
    "estimated_delivery_days" => [
      "label" => "Estimated delivery days",
      "type" => "varchar",
      "input" => "text",
      "required" => false,
      "user_defined" => false,
      "unique" => false,
      "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
      "visible" => true,
      "searchable" => false,
      "filterable" => false,
      "comparable" => false,
      "visible_on_front" => true,
      "is_html_allowed_on_front" => true,
      "is_used_for_price_rules" => false,
      "is_filterable_in_search" => false,
      "used_in_product_listing" => true,
      "used_for_sort_by" => false,
      "is_configurable" => false,
      "is_visible_in_advanced_search" => false,
      "position" => false,
      "is_wysiwyg_enabled" => false,
      "is_used_for_promo_rules" => false,
    ],
    "campaign_original_price" => [
      "label" => "Campaign original price",
      "type" => "varchar",
      "input" => "text",
      "required" => false,
      "user_defined" => false,
      "unique" => false,
      "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
      "visible" => true,
      "searchable" => false,
      "filterable" => false,
      "comparable" => false,
      "visible_on_front" => true,
      "is_html_allowed_on_front" => true,
      "is_used_for_price_rules" => false,
      "is_filterable_in_search" => false,
      "used_in_product_listing" => true,
      "used_for_sort_by" => false,
      "is_configurable" => false,
      "is_visible_in_advanced_search" => false,
      "position" => false,
      "is_wysiwyg_enabled" => false,
      "is_used_for_promo_rules" => false,
    ],
];

// Add all new attributes
foreach ($newAttributes as $attributeName => $attributeData) {

    // Check if attribute already exists
    if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

        // Add attribute
        // if attribute value 'group' is not empy OR attribute value 'user_defined' is empty (false), then new attribute is automatically added to all attribute sets
        // and then if attribute value 'group' is not empy, attribute is added to speciefied attribute group, otherwise it is added to the default attribute group.
        $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);

    }
}

$installer->endSetup();
