<?php

class Crossroads_Awardit_Awardit_TreeController extends Crossroads_API_Controller_Resource {
    protected $CATEGORY_PROPS_EXCLUDE = [
        "includeInMenu"   => true,
        "isAnchor"        => true,
        "level"           => true,
        "metaDescription" => true,
        "metaTitle"       => true,
        "parentId"        => true,
        "path"            => true,
        "position"        => true,
        "url"             => true,
        "urlKey"          => true,
    ];

    public function getAll() {
        // Verify token
        $_token  = Mage::helper("awardit")->getToken($this->getRequest());

        Mage::log(sprintf("%s: Started", __METHOD__));

        $store   = Mage::app()->getStore();
        $factory = Mage::getModel("API/factory");
        $catSer  = $factory->createCategorySerializer($store);

        $res = [200, $this->prepareCategory($store, $catSer, $store->getRootCategoryId())];

        Mage::log(sprintf("%s: Finished response", __METHOD__));

        return $res;
    }

    protected function prepareCategory($store, $catSer, $parentId = null) {
        $rootId  = $store->getRootCategoryId();

        $category   = Mage::getModel("catalog/category")->load($parentId ?: $rootId);
        $categories = Mage::getModel('catalog/category')
            ->getCollection()
            ->setStoreId($store->getId())
            ->addFieldToFilter('is_active', 1)
            ->addAttributeToFilter('path', ['like' => "1/{$rootId}/%"])
            ->addAttributeToSelect('*')
            ->addAttributeToSort("position");

        if($parentId) {
            $categories->addFieldToFilter("parent_id", $parentId);
        }

        return [
            "category" => array_diff_key($catSer->serializeItem($category), $this->CATEGORY_PROPS_EXCLUDE),
            "categories" => array_values(array_map(function($c) use($store, $catSer) {
                return $this->prepareCategory($store, $catSer, $c->getId());
            }, $categories->getItems())),
        ];
    }

    public function getItem($id) {
        return [404];
    }
}
