<?php

class Crossroads_Awardit_Model_Observer extends Mage_Core_Model_Abstract {
    public function registerPayment(Varien_Event_Observer $observer) {
        $observer->getRegistry()->addMethod(new Crossroads_Awardit_Payment());
    }

    public function addAwarditCustomerId(Varien_Event_Observer $observer) {
        $params = $observer->getParams();
        $quote  = $observer->getQuote();

        if( ! empty($params["awarditCustomerId"])) {
            $quote->setAwarditCustomerId($params["awarditCustomerId"]);
        }
    }

    public function checkoutPostDataPrepare(Varien_Event_Observer $observer) {
        $params = $observer->getPreparedData();
        $quote  = $observer->getQuote();

        $params->setData("awarditCustomerId", $quote->getAwarditCustomerId());
    }

    public function onApiCheckoutPostCreateValidation(Varien_Event_Observer $observer): void {
        $quote = $observer->getQuote();

        $quote->setBypassPointRequirement(true);
    }
}
