<?php

class Crossroads_Awardit_Block_Info_Invoice extends Mage_Payment_Block_Info {
    protected function _construct() {
        parent::_construct();

        $this->setTemplate("payment/info/awardit.phtml");
    }

    protected function _prepareSpecificInformation($transport = null) {
        if($this->_paymentSpecificInformation) {
            return $this->_paymentSpecificInformation;
        }

        $helper  = Mage::helper("awardit");
        $payment = $this->getInfo();

        $transport = new Varien_Object();
        $transport = parent::_prepareSpecificInformation($transport);

        if(Mage::getDesign()->getArea() === "adminhtml") {
            $companyId = $payment->getAdditionalInformation(Crossroads_Awardit_Helper_Data::FIELD_COMPANY_ID);
            $token     = $payment->getAdditionalInformation(Crossroads_Awardit_Helper_Data::FIELD_TOKEN);

            $transport->addData([
                $helper->__("Company ID") => $companyId,
                $helper->__("Used token") => $token,
            ]);
        }

        return $transport;
    }
}
