<?php

class Crossroads_Awardit_Awardit_StockinfoController extends Crossroads_API_Controller_Resource {
    public function getAll() {
        return [404];
    }

    public function getItem($id) {
        // Verify token
        $_token  = Mage::helper("awardit")->getToken($this->getRequest());
        $store   = Mage::app()->getStore();
        $factory = Mage::getModel("API/factory");
        $prodSer = $factory->createProductDetailSerializer($store);
        $ids     = array_filter(array_map("trim", explode(",", $id)));

        return [200, array_values(array_filter(array_map(function($id) use($prodSer) {
            $product = Mage::getModel("catalog/product")->load($id);

            if( ! $product || ! $product->getId() || $product->isDisabled()) {
                return null;
            }

            $data = $prodSer->serializeItem($product);

            return [
                "id"     => $data["id"],
                "sku"    => $data["sku"],
                "manage" => $data["stockManage"],
                "qty"    => $data["stockQty"],
            ];
        }, $ids)))];
    }
}
