<?php

class Crossroads_Awardit_Awardit_ProductsController extends Crossroads_API_Controller_Resource {
    protected $PRODUCT_PROPS_EXCLUDE = [
        "customOptions",
        "discountPercent",
        "isPercent",
        "metaDescription",
        "originalPrice",
        "position",
        "relatedProducts",
        "selections",
        "specialPrice",
        "stockBackorders",
        "urlKey",
        "useAsDefault",
    ];

    public function getAll() {
        $req = $this->getRequest();
        // Verify token
        $_token = Mage::helper("awardit")->getToken($req);

        $model = Mage::getModel("awardit_upsert/api");

        $model->setLocalStore(Mage::app()->getStore());

        $data = $model->listProductsAction($req->getParams());

        return [200, $data];
    }

    public function getItem($id) {
        // Verify token
        $_token = Mage::helper("awardit")->getToken($this->getRequest());
        $store = Mage::app()->getStore();
        $model = Mage::getModel("awardit_upsert/api");
        $product = Mage::getModel("catalog/product")->load($id);

        if( ! $product || ! $product->getId() || ! $product->isVisibleInSiteVisibility() || $product->isDisabled()) {
            return [404];
        }

        $model->setLocalStore($store);

        $data = $model->listProductsAction($this->getRequest()->getParams(), $product->getSku());

        if(empty($data)) {
            return [404];
        }

        return [200, current($data)];
    }
}
