<?php

class Crossroads_Awardit_Awardit_OrdersController extends Crossroads_API_Controller_Resource {
    public function getAll() {
        return [404];
    }

    public function getItem($id) {
        $token     = Mage::helper("awardit")->getToken($this->getRequest());
        $order     = Mage::getModel("sales/order")->loadByIncrementId($id);
        $companyId = $token->getCompanyId();

        if(!$order || !$order->getIncrementId() || !$order->getPayment() || $order->getPayment()->getAdditionalInformation(Crossroads_Awardit_Helper_Data::FIELD_COMPANY_ID) != $companyId) {
            return [404];
        }

        return [200, [
            "id"              => $order->getIncrementId(),
            "status"          => $order->getStatus(),
            "shippingTracker" => array_values(array_map(function($t) {
                return $t->getNumber();
            }, $order->getTracksCollection()->getItems())),
            "createdAt"       => gmdate("Y-m-d\TH:i:s\Z", strtotime($order->getCreatedAt())),
        ]];
    }
}
