<?php

class Crossroads_Awardit_Model_Product_Decorator extends Crossroads_API_Model_Serializer_Decorator {
    protected $exclude = [];
    protected $rate = 1;

    public function __construct(array $params = []) {
        parent::__construct($params);

        if(array_key_exists("exclude", $params)) {
            $this->setExclude($params["exclude"]);
        }

        if(array_key_exists("rate", $params)) {
            $this->rate = $params["rate"];
        }
        else {
            $this->rate = Mage::helper("awardit_points")->getRate(Mage::app()->getStore());

            Mage::log($this->rate);
        }
    }

    public function setExclude($exclude) {
        $this->exclude = array_combine($exclude, array_fill(0, count($exclude), true));

        return $this;
    }

    public function setRate($rate) {
        $this->rate = $rate;

        return $this;
    }

    protected function postItem($item, $data) {
        $data = array_diff_key($data, $this->exclude);

        if($data["options"]) {
            $data["options"] = array_map(function($o) {
                $o["values"] = array_map(function($p) {
                    return array_diff_key($p, $this->exclude);
                }, $o["values"]);

                return array_diff_key($o, $this->exclude);
            }, $data["options"]);
        }

        $data["tax"] = Mage::helper("tax")->getPrice($item, $item->getFinalPrice(), true) - $data["price"];
        $data["points"] = ceil((float)$data["price"] * $this->rate);

        return $data;
    }

    protected function preItem($item) {
        $product = Mage::getModel("catalog/product")->load($item->getId());

        return $product;
    }
}
