<?php

namespace Awardit\Aws\Lambda;

use Monolog\LogRecord;
use Monolog\Handler\TestHandler;
use DateTimeImmutable;

/**
 * Class containing methods for using Monolog 1.0 to 3.0.
 *
 * @psalm-type MonologArrayRecord array{
 *   channel: string,
 *   context: Array<mixed>,
 *   datetime: DateTimeImmutable,
 *   extra: Array<mixed>,
 *   level: 100|200|250|300|400|500|550|600,
 *   level_name: "ALERT"|"CRITICAL"|"DEBUG"|"EMERGENCY"|"ERROR"|"INFO"|"NOTICE"|"WARNING",
 *   message: string
 * }
 */
class MonologCompat
{
    /**
     * @return Array<string>
     */
    public static function getHandlerMessages(TestHandler $handler): array
    {
        return array_map(
            /**
             * @param LogRecord|MonologArrayRecord $m
             */
            fn($m): string => $m instanceof LogRecord ? $m->toArray()["message"] : $m["message"],
            $handler->getRecords()
        );
    }
}
