<?php

declare(strict_types=1);

namespace Awardit\Aws\Lambda;

/**
 * AWS Lambda request handler.
 *
 * @api
 * @template T of Array<string, mixed>
 * @template U of Array<string, mixed>
 */
interface HandlerInterface
{
    /**
     * Handles an incoming Lambda request.
     *
     * NOTE: Exceptions will be handled by the runtime and automaically logged.
     *
     * @psalm-param Request<T> $request
     * @psalm-return U
     * @return Array<string, mixed> The JSON body response, format depends on
     *                              type of lambda.
     */
    public function handle(Request $request): array;
}
