<?php

declare(strict_types=1);

namespace Awardit\Aws\Lambda;

use stdClass;
use PHPUnit\Framework\TestCase;

class CallbackHandlerTest extends TestCase
{
    public function testHandle(): void
    {
        $req = new Request(
            /* invocationId: */            "test-invoke",
            /* traceId: */ "a-trace",
            /* payload: */ ["test" => "request"],
        );
        $fn = $this->getMockBuilder(CallbackHandlerTestCallback::class)->getMock();

        $fn->expects($this->once())
            ->method('__invoke')
            ->with(["test" => "request"])
            ->willReturn(["response" => "test"]);

        /** @var callable(Array<string, mixed>): Array<string, mixed> $fn */
        $handler = new CallbackHandler($fn);

        $this->assertEquals(["response" => "test"], $handler->handle($req));
    }
}

// phpcs:disable
/**
 * Class imitating a Closure, since PHPUnit will no longer be able to add
 * methods and cannot extend final classes.
 */
class CallbackHandlerTestCallback
{
    public function __invoke(array $_req): array
    {
        return [];
    }
}
// phpcs:enable
