<?php

declare(strict_types=1);

use Awardit\Aws\Lambda\Runtime;
use Awardit\Aws\Lambda\CallbackHandler;
use Awardit\Aws\Logger;

require_once dirname(__DIR__) . "/vendor/autoload.php";

// Register log handler for all errors/warnings/uncaught exceptions
Logger::registerErrorHandler();

// Lambda runtime
$runtime = Runtime::fromEnv();

try {
    // Initialize our Lambda application
    $log = Logger::getLogger("my-app");
    $app = new CallbackHandler(function (array $request) use ($log): array {
        $log->debug("Got lambda request", [
            "request" => $request,
        ]);

        return [
            "statusCode" => 200,
            "body" => "Lambda response",
        ];
    });
} catch (Throwable $t) {
    // We failed to initialize our lambda, notify the runtime about it
    $runtime->sendInitializationException($t);

    // Rethrow since we failed
    throw $t;
}

// Has to be outside the initialization try-catch to not trigger an
// initialization error when the runtime exits or if we get any runtime errors
$runtime->run($app);
