<?php

declare(strict_types=1);

namespace Awardit\Aws;

use Throwable;
use GuzzleHttp\Client;
use Awardit\Aws\Ecs\ContainerMetadata;

/**
 * Helper for interacting with ECS information.
 * @api
 */
class Ecs
{
    /**
     * @api
     * @throws Exception if ECS_CONTAINER_METADATA_URI_V4 environment variable is not set.
     */
    public static function getCurrentContainerMetadata(): ?ContainerMetadata
    {
        $log = Logger::getLogger("ecs");
        $client = new Client();

        try {
            $metadataUrl = Env::mustGetValue("ECS_CONTAINER_METADATA_URI_V4");

            $res = $client->get($metadataUrl);

            return new ContainerMetadata(Json::decode((string)$res->getBody()));
        } catch (Throwable $t) {
            $log->error($t->getMessage(), ["exception" => $t]);

            return null;
        }
    }
}
