<?php

declare(strict_types=1);

namespace Awardit\Aws;

use JsonException;
use PHPUnit\Framework\TestCase;

use function putenv;

class JsonTest extends TestCase
{
    public function testJsonDecode(): void
    {
        $this->expectException(JsonException::class);

        Json::decode("abc");
    }

    public function testJsonDecode2(): void
    {
        $this->expectException(JsonException::class);
        $this->expectExceptionMessage("Invalid JSON body: Expected associative array, got int");

        Json::decode("123");
    }

    public function testJsonDecode3(): void
    {
        $value = Json::decode('{"test":"value"}');

        $this->assertEquals(["test" => "value"], $value);
    }

    public function testJsonEncode(): void
    {
        $this->assertEquals('{"foo":"test"}', Json::encode(["foo" => "test"]));
        $this->assertEquals('{"value":0.0}', Json::encode(["value" => 0.0]));
        $this->assertEquals('{"value":"some/slashes"}', Json::encode(["value" => "some/slashes"]));
    }
}
