#!/bin/sh

set -ex

PHP_VERSION="${PHP_VERSION:-"7.4"}"
PHP_IMAGE="${PHP_IMAGE:-"registry.awardit.dev/crossroads/images/php:${PHP_VERSION}-cli-dev"}"

docker run --rm -it \
  -v "${PWD}:${PWD}" \
  -w "${PWD}" \
  -e "XDG_CACHE_HOME=/tmp" \
  --tmpfs "/tmp" \
  -u "$(id -u):$(id -g)" \
  ${PHP_IMAGE} "$@"
