<?php

declare(strict_types=1);

namespace Awardit\Aws;

use PHPUnit\Framework\TestCase;

use function putenv;

class EnvTest extends TestCase
{
    public function testGetValue(): void
    {
        $value = Env::getValue("PATH");
        $this->assertIsString($value);
        $this->assertStringContainsString("bin", $value);

        putenv("AWARDIT_AWS_TEST_VARIABLE");

        $value = Env::getValue("AWARDIT_AWS_TEST_VARIABLE");
        $this->assertNull($value);

        putenv("AWARDIT_AWS_TEST_VARIABLE=foo");

        $value = Env::getValue("AWARDIT_AWS_TEST_VARIABLE");
        $this->assertEquals("foo", $value);

        putenv("AWARDIT_AWS_TEST_VARIABLE");

        $value = Env::getValue("AWARDIT_AWS_TEST_VARIABLE");
        $this->assertNull($value);
    }

    public function testMustGetValue(): void
    {
        $this->expectException(Exception::class);
        $this->expectExceptionMessage("Missing AWARDIT_AWS_TEST_VARIABLE environment variable");

        putenv("AWARDIT_AWS_TEST_VARIABLE");

        Env::mustGetValue("AWARDIT_AWS_TEST_VARIABLE");
    }

    public function testMustGetValue2(): void
    {
        putenv("AWARDIT_AWS_TEST_VARIABLE=bar");

        $value = Env::mustGetValue("AWARDIT_AWS_TEST_VARIABLE");
        $this->assertEquals("bar", $value);
    }
}
