<?php

declare(strict_types=1);

namespace Awardit\Aws\Lambda;

/**
 * Interface for a Cloud Formation Custom Resource lambda implementation.
 *
 * Note that any failure should throw an exception, if the Custom Resource
 * Provider framework is being used (ie. CDK customresources.Provider).
 *
 * @api
 * @see https://github.com/aws/aws-cdk/tree/main/packages/aws-cdk-lib/custom-resources#provider-framework
 */
interface CustomResourceInterface
{
    /**
     * Invoked on a resource create event.
     *
     * @param Array<string, mixed> $resourceProperties
     */
    public function create(array $resourceProperties): CustomResourceResponse;

    /**
     * Invoked on a resource update event.
     *
     * @param Array<string, mixed> $resourceProperties
     */
    public function update(array $resourceProperties): CustomResourceResponse;

    /**
     * Invoked on a resource delete event.
     *
     * @param Array<string, mixed> $resourceProperties
     */
    public function delete(array $resourceProperties): CustomResourceResponse;
}
