<?php

declare(strict_types=1);

namespace Awardit\Aws;

use JsonException;
use PHPUnit\Framework\TestCase;

use function putenv;

class UtilTest extends TestCase
{
    public function testGetAwsSdkCommonConfig(): void
    {
        putenv("AWS_ENDPOINT_URL");
        putenv("AWS_REGION");
        putenv("AWS_DEFAULT_REGION");

        $value = Util::getAwsSdkCommonConfig();
        $this->assertEquals(["region" => "us-east-1"], $value);

        putenv("AWS_REGION=eu-north-1");

        $value = Util::getAwsSdkCommonConfig();
        $this->assertEquals(["region" => "eu-north-1"], $value);

        putenv("AWS_DEFAULT_REGION=eu-west-1");

        $value = Util::getAwsSdkCommonConfig();
        $this->assertEquals(["region" => "eu-north-1"], $value);

        putenv("AWS_REGION");

        $value = Util::getAwsSdkCommonConfig();
        $this->assertEquals(["region" => "eu-west-1"], $value);

        putenv("AWS_ENDPOINT_URL=http://localhost:1234");

        $value = Util::getAwsSdkCommonConfig();
        $this->assertEquals(["region" => "eu-west-1", "endpoint" => "http://localhost:1234"], $value);
    }

    public function testGetExceptionTraceAsList(): void
    {
        $list = Util::getExceptionTraceAsList(new Exception());

        // $this->assertIsList($list);
        $n = 0;

        foreach ($list as $i => $item) {
            $this->assertEquals($n++, $i);
            $this->assertMatchesRegularExpression("/[^:]+:\d+$/", $item);
        }
    }
}
