<?php

declare(strict_types=1);

namespace Awardit\Aws\Lambda;

use JsonException;
use Awardit\Aws\Exception;
use Nyholm\Psr7\Response;
use PHPUnit\Framework\TestCase;

class RequestTest extends TestCase
{
    public function testFromLambdaPsrResponseEmpty(): void
    {
        $this->expectExceptionMessageMatches("/Lambda-Runtime-Aws-Request-Id/");
        $this->expectException(Exception::class);

        Request::fromLambdaPsrResponse(new Response(200));
    }

    public function testFromLambdaPsrResponseBadJson(): void
    {
        $this->expectException(JsonException::class);

        Request::fromLambdaPsrResponse(new Response(
            200,
            [
                "Lambda-Runtime-Aws-Request-Id" => "test-id",
            ],
            "{"
        ));
    }

    public function testFromLambdaPsrResponse(): void
    {
        $request = Request::fromLambdaPsrResponse(new Response(
            200,
            [
                "Lambda-Runtime-Aws-Request-Id" => "test-id",
            ],
            '{"some":"data"}'
        ));

        $this->assertEquals("test-id", $request->getInvocationId());
        $this->assertEquals(null, $request->getTraceId());
        $this->assertEquals(["some" => "data"], $request->getPayload());
    }

    public function testFromLambdaPsrResponse2(): void
    {
        $request = Request::fromLambdaPsrResponse(new Response(
            200,
            [
                "Lambda-Runtime-Aws-Request-Id" => "test-id",
                "Lambda-Runtime-Trace-Id" => "some-trace",
            ],
            '{"some":"data"}'
        ));

        $this->assertEquals("test-id", $request->getInvocationId());
        $this->assertEquals("some-trace", $request->getTraceId());
        $this->assertEquals(["some" => "data"], $request->getPayload());
    }
}
