<?php

declare(strict_types=1);

namespace Awardit\Aws\Ecs;

/**
 * Metadata for a container.
 */
class ContainerMetadata
{
    /**
     * @param Array<string, mixed>
     */
    private array $data;

    /**
     * @param Array<string, mixed> $data
     */
    public function __construct(
        array $data
    ) {
        $this->data = $data;
    }

    /**
     * Returns the task identifier for the container.
     *
     * @api
     */
    public function getTaskId(): ?string
    {
        // ARN for container/task
        // Format:
        // * ContainerARN: arn:aws:ecs:eu-north-1:209989591807:container/basic-ec2/7c1d7f36eeab4788ae6e2653b89e83c0/76edcc26-dc85-40cb-96ef-a751f86ff710
        // * TaskARN: arn:aws:ecs:eu-north-1:209989591807:task/basic-ec2/7c1d7f36eeab4788ae6e2653b89e83c0
        $containerArn = $this->data["ContainerARN"] ?? $this->data["Labels"]["com.amazonaws.ecs.task-arn"] ?? "";

        if (!is_string($containerArn)) {
            return null;
        }

        $id = explode("/", $containerArn)[2] ?? null;

        if ($id === null || strlen($id) === 0) {
            return null;
        }

        return $id;
    }
}
