<?php

declare(strict_types=1);

namespace Awardit\Aws\Lambda;

/**
 * Interface for a Cloud Formation Custom Resource lambda implementation.
 *
 * @api
 */
interface CustomResourceInterface
{
    /**
     * Invoked on a resource create event.
     *
     * @param Array<string, mixed> $resourceProperties
     */
    public function create(array $resourceProperties): CustomResourceResponse;

    /**
     * Invoked on a resource update event.
     *
     * @param Array<string, mixed> $resourceProperties
     */
    public function update(array $resourceProperties): CustomResourceResponse;

    /**
     * Invoked on a resource delete event.
     *
     * @param Array<string, mixed> $resourceProperties
     */
    public function delete(array $resourceProperties): CustomResourceResponse;
}
