<?php

declare(strict_types=1);

namespace Awardit\Aws\Lambda;

use Awardit\Aws\Exception;

/**
 * Lambda handler wrapping a callback.
 *
 * Note: By default only typed to array with string keys.
 *
 * @api
 * @template T as Array<string, mixed>
 * @template U as Array<string, mixed>
 * @implements HandlerInterface<T, U>
 */
class CallbackHandler implements HandlerInterface
{
    public function __construct(
        /**
         * The custom resource implementation.
         *
         * @var callable(T): U
         */
        private $callback
    ) {
    }

    public function handle(Request $request): array
    {
        return ($this->callback)($request->getPayload());
    }
}
